' ----------------------------------------------------------------------------
' external Win32 API functions
' ----------------------------------------------------------------------------
Extern "Win32"

	Function SetWindowLong:Int(HWND:Int, nIndex:Int, dwNewLong:Int) = "SetWindowLongA@12"
	Function GetWindowLong:Int(HWND:Int, nIndex:Int) = "GetWindowLongA@8"
	Function CallWindowProc:Int(prevwndproc:Int, hwnd:Int, MSG:Int, wparam:Int, lparam:Int) = "CallWindowProcA@20"
	Function SetWindowPos:Int(hWnd:Int, hAfter:Int, X:Int, Y:Int, cx:Int, cy:Int, flags:Int)

EndExtern



' ----------------------------------------------------------------------------
' help function to keep the window active in background
' ----------------------------------------------------------------------------
Function WindowFunc:Int(hwnd:Int, MSG:Int, wparam:Int, lparam:Int) "Win32"

	Select MSG
				
		Case WM_DESTROY
						SetWindowLong(hwnd, GWL_WNDPROC, OldWindowFunc)
			
	End Select

	Return CallWindowProc(OldWindowFunc, hwnd, MSG, wparam, Int(lparam))

End Function



' ----------------------------------------------------------------------------
' help function to keep the window active in background
' ----------------------------------------------------------------------------
Function SetWindowFunc:Int(Window:TGadget, newfunc:Int(hwnd:Int, MSG:Int, wparam:Int, lparam:Int))
	
	Local hwnd:Int = QueryGadget(Window, QUERY_HWND)
	Local oldfunc:Int = GetWindowLong(hwnd, GWL_WNDPROC)
	
	SetWindowLong(hwnd, GWL_WNDPROC, Int(Byte Ptr newfunc))
	
	Return oldfunc
	
End Function




' ----------------------------------------------------------------------------
' help function to set a given window topmost (always on top feature)
' ----------------------------------------------------------------------------
Function SetWindowTopMost(Gadget:TGadget, top:Int = True)

	Local Mode:Int
	
	If top Then Mode = HWND_TOPMOST Else Mode = HWND_NOTOPMOST

	SetWindowPos QueryGadget(Gadget, QUERY_HWND), Mode, GadgetX(Gadget), GadgetY(Gadget), GadgetWidth(Gadget), GadgetHeight(Gadget), 0
	
End Function